\name{stark.test}
\alias{stark.test}
\alias{stark.test.Z}
\alias{stark.pairwise.test}

\title{ stark.test }
\description{
  These main methods conduct the test of the election audit and returns a p-value and
  other related info on that test.

  It is an older method.  Most likely \code{\link{CAST.audit}} or
  \code{\link{trinomial.audit}} should be used instead.
}
\usage{
stark.test(votes, audits, C.names = NULL,
                f = 1, pool = TRUE, pairwise = FALSE, ...)
stark.test.Z(Z, calc.e_p = calc.pairwise.e_p,
        w_p = weight.function("no.weight"),
        max_err = maximumMarginBound, bound.col = Z$tot.votes.col,
        strat.col = NULL, drop = NULL, 
        strat.method = NULL, err.override = NULL,
        n = NULL, t = NULL, q = NULL)
stark.pairwise.test(votes, audits, C.names = NULL,
        f = 1, pool = TRUE, ...)
}

\arguments{
  \item{votes}{ data.frame of votes. Each row is precinct. }
  \item{audits}{ data.frame of audits. Each row is precinct.  Table reports overstatement by
                       candidate.}
  \item{C.names}{ Names of candidates (and names of cor columns in votes
  and audits tables.  If NULL will derive from cols 2 on of votes}
  \item{f}{ The number of winners }
  \item{pool}{If TRUE, combine small candidates into single pseudo-candidates to increase power }
  \item{pairwise}{if TRUE then do a pairwise test for all pairs and return
                       highest p-value }
  \item{Z}{ The object holding all the voting information.  See below
  for details.}

  \item{calc.e_p}{ The Function used to calculate maximum error bounds }
  \item{w_p}{ The function used to calculate weights of error
                   (A list of two functions) }
  \item{max_err}{ Function to compute max error bounds for each
  precint }
  \item{bound.col}{Name (or column index) of column in the vote matrix
  corresponding to maximum number of votes allowed in precinct. }
  \item{strat.col}{ Name of column that determines how to stratify  
  if NULL will not stratify  }
  \item{strat.method}{ Not currently implemented. }
  \item{err.override}{ If non-null, use this as the found error in votes rather than the actual errors found in the audit.}
  \item{n}{  Elements of the test statistic.  Can pass to avoid computation
                   if those values are already known (e.g., for a
  simulation) }
  \item{t}{  Elements of the test statistic.  Can pass to avoid computation
                   if those values are already known (e.g., for a simulation) }
  \item{q}{  Elements of the test statistic.  Can pass to avoid computation
                   if those values are already known (e.g., for a
                   simulation) }
  \item{drop}{ Either a vector of TRUE/FALSE or a name of a column in
  Z\$V of T/F values.  Precincts identified by drop will be dropped from
  calculations. }
                 
   \item{\dots}{ Extra arguments passed directly to the work-horse method stark.test.Z }
  

 }
 
\details{
    stark.test() will do the entire test. It is basically a driver function that sets up 'Z' matrix and passes buck
    to the stark.test.Z

    The Z object, in particular has:
           Z\$V:     The table of reported votes 
           Z\$audit: The table of audits as differences from 
                              recorded votes 
}
\value{
Return an htest object with pvalue, some relevant statistics, and the Z
object used (possibly constructed) that produced those results. 
}
\examples{
## pretending that santa cruz audit was a SRS audit (which it was not)
data(santa.cruz)
Z = elec.data(santa.cruz, C.names=c("leopold","danner"))
data(santa.cruz.audit)
## do some work to get the audit totals to overstatements
rownames(santa.cruz.audit) = santa.cruz.audit$PID
Z$audit = audit.totals.to.OS(Z, santa.cruz.audit)
Z$audit
stark.test.Z(Z)

}         
\seealso{
  See \code{\link{elec.data}} for description of the main object.  See 
  \code{\link{find.q}} and \code{\link{compute.stark.t}} for the main
           components of this test.  \code{\link{find.stark.SRS.p}} is a
           utility function for computing a p-value for a specific
           situation.  See \link{weight.function} for functions used to
           weight audit errors.  See \link{MaximumBounds} for different
           bounds on error that one might use for these tests.  See \code{\link{find.stratification}} for a utility for stratification.
}

\author{
  Luke W. Miratrix
}
