% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evals.R
\name{get_evals}
\alias{get_evals}
\alias{get_evals.data.frame}
\alias{get_evals.elastic_mean}
\title{Evaluate a curve on a grid}
\usage{
get_evals(curve, t_grid = NULL, ...)

\method{get_evals}{data.frame}(curve, t_grid = NULL, ...)

\method{get_evals}{elastic_mean}(curve, t_grid = NULL, centering = TRUE, ...)
}
\arguments{
\item{curve}{a one parameter function which is to be evaluated on a grid}

\item{t_grid}{the curve is evaluated at the values in t_grid, first value needs
to be 0, last value needs to be 1.
If t_grid = NULL, a default regular grid with grid length 0.01 is chosen}

\item{...}{other arguments}

\item{centering}{TRUE if curves shall be centered}
}
\value{
a \code{data.frame} with evaluations of the curve
at the values in \code{t_grid} in its rows.
}
\description{
Evaluate a curve on a grid
}
\examples{
curve <- function(t){c(t*sin(10*t), t*cos(10*t))}
plot(get_evals(curve), type = "b")
}
