% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eive.R
\name{eive.cga.formula}
\alias{eive.cga.formula}
\title{Performs CGA based errors-in-variables correction for given formula and data.
A single independent variable is supposed to be measured subject to error.}
\usage{
eive.cga.formula(formula, data, dirtyx.varname, numdummies = 10, popsize = 20)
}
\arguments{
\item{formula}{Formula object.}

\item{data}{data.frame that holds the regression data.}

\item{dirtyx.varname}{String key value of the erroneous independent variable.}

\item{numdummies}{Number of dummy variables used in auxiliary regression.}

\item{popsize}{Population size parameter for compact genetic algorithm. 
1/popsize is the mutation rate.}
}
\value{
A list() of regression equations.
}
\description{
Performs CGA based errors-in-variables correction for given formula and data.
A single independent variable is supposed to be measured subject to error.
}
\section{Slots}{

\describe{
\item{\code{ols}}{lm object calculated using original values}

\item{\code{eive}}{lm object calculated using the predicted variable by eive}

\item{\code{proxy}}{lm object of proxy regression obtained by genetic search.}

\item{\code{cleanedx}}{Error-free estimate of the x variable (dirtyx) 
that is measured with error.}

\item{\code{measurementerror}}{Estimate of the measurement error.}
}}

\examples{
set.seed(12345)
n <- 30
clean_x <- rnorm(n, mean = 10, sd = sqrt(7))
delta_x <- rnorm(n, mean = 0, sd = sqrt(3))

e <- rnorm(n, mean = 0, sd = sqrt(5))
y <- 20 + 10 * clean_x + e

dirty_x <- clean_x + delta_x

mydata <- data.frame(y = y, dirtyx = dirty_x)

result <- eive.cga.formula(
     formula = y ~ dirtyx,
     dirtyx.varname = "dirtyx",
     data = mydata,
     numdummies = 10
)
}
\seealso{
eive.cga
}
