% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-coefficients.r
\name{coefficientComparisonPlot}
\alias{coefficientComparisonPlot}
\title{Diagnostic monitor plots for EICM}
\usage{
coefficientComparisonPlot(model, true.model, nenv.to.plot = 0,
  nlatent.to.plot = 0, plot.interactions = any(model$sp != 0),
  plot.intercept = FALSE, excluded.interactions = NULL,
  layout = TRUE, noplot = FALSE, env.stats = TRUE, legend = TRUE)
}
\arguments{
\item{model}{the EICM model of interest.}

\item{true.model}{the true model to compare with (usually, the one used for simulating the data).}

\item{nenv.to.plot}{the number of environmental variables to plot.}

\item{nlatent.to.plot}{the number of latent variables to plot.}

\item{plot.interactions}{logical. Plot interaction coefficient scatterplot?}

\item{plot.intercept}{logical. plot the species-level intercepts?}

\item{excluded.interactions}{a binary species x species matrix telling which interactions were excluded \emph{a priori}.}

\item{layout}{logical. Do multi-panel layout?}

\item{noplot}{logical. Do plots? If TRUE, it will return the accuracy statistics only.}

\item{env.stats}{logical. Compute accuracy for environmental predictors?}

\item{legend}{logical. Plot legend?}
}
\value{
A vector with accuracy statistics.
}
\description{
Visually compare the true model with estimation results (final results or during model fitting)
and compute accuracy statistics.
}
