% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{evaluateBounds}
\alias{evaluateBounds}
\title{Evaluate computed bounds, across confidence levels, applying the selection heuristic of Jiang et al. 2019}
\usage{
evaluateBounds(outputListFromGenerateBounds)
}
\arguments{
\item{outputListFromGenerateBounds}{List returned by generateBounds()}
}
\value{
List object with the bounds indexed across confidence levels:

 x_for_x_in_CI_x c(0.00,0.25,0.50,0.75, 1.00, 1.25, 1.50, 1.75, 2.00), which corresponds to CI_0, CI_0.25, ..., CI_2.00 (the following vectors are parallel in indexes)

 CI_x_lower CI_x lower bound

 CI_x_upper CI_x upper bound

 CI_x_isSelected If FALSE, proposed bound was not rejected by the heuristic (if TRUE, bounds are reverted to the DD bounds)

 CI_x_widthRatio |CI_x|/|DD|

 CI_x_nominalCoverage Nominal coverage (1-pnorm(-x_for_x_in_CI_x))


 Optional: CI_x_truthCaptured If true district Beta is provided in outputListFromGenerateBounds, then this vector contains a boolean for whether or not the
  true value was captured in the proposed CI_x.
}
\description{
\code{evaluateBounds()} calculates the bounds across confidence levels and generates the width-ratio relative to the deterministic DD bounds using the
bounds generated by generateBounds(), after applying the selection heuristic of Jiang et al. 2019. If the true district B is provided,
the capture of the true value is checked.
}
\examples{
library("MASS")
library("eco")
data("census")
inputDataSet <- census
x <- inputDataSet$X
t <- inputDataSet$Y
n <- inputDataSet$N
trueBetaB <- inputDataSet$W1
outputList <- generateBounds(x, t, n, trueBetaB=trueBetaB, useXRangeOffset=TRUE,
    returnAdditionalStats=FALSE, printSummary=TRUE)
summaryOutputList <- evaluateBounds(outputList)

# $x$ & Nominal coverage (\\Phi(x)) & True B in CI_x & Width-ratio: |Proposed width|/|DD| &
#     Reverted to DD & Proposed Lower & Proposed Upper \\\\
# 0.00 & 0.5000 & TRUE & 0.4653 & FALSE & 0.6061 & 0.8101\\\\
# 0.25 & 0.5987 & TRUE & 0.5028 & FALSE & 0.5977 & 0.8182\\\\
# 0.50 & 0.6915 & TRUE & 0.5404 & FALSE & 0.5893 & 0.8262\\\\
# 0.75 & 0.7734 & TRUE & 0.5780 & FALSE & 0.5809 & 0.8343\\\\
# 1.00 & 0.8413 & TRUE & 0.6155 & FALSE & 0.5726 & 0.8424\\\\
# 1.25 & 0.8944 & TRUE & 0.6531 & FALSE & 0.5642 & 0.8505\\\\
# 1.50 & 0.9332 & TRUE & 0.6906 & FALSE & 0.5558 & 0.8586\\\\
# 1.75 & 0.9599 & TRUE & 0.7282 & FALSE & 0.5474 & 0.8666\\\\
# 2.00 & 0.9772 & TRUE & 0.7657 & FALSE & 0.5390 & 0.8747\\\\

# For example, CI_0.5 (0.5893336 0.8262426) corresponds to
#     c(summaryOutputList$CI_x_lower[3], summaryOutputList$CI_x_upper[3])

}
