% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tpchreg.R
\name{plot.tpchreg}
\alias{plot.tpchreg}
\title{Plots output from a tpchreg regression}
\usage{
\method{plot}{tpchreg}(
  x,
  fn = c("haz", "cum", "sur"),
  log = "",
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Duration",
  ylab = "",
  col,
  lty,
  printLegend = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{tpchreg} object}

\item{fn}{Which functions should be plotted? Default is the hazard function.}

\item{log}{character, "" (default), "y", or "xy".}

\item{main}{Header for the plot}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{xlab}{x label}

\item{ylab}{y label}

\item{col}{Color(s) for the curves. Defaults to black.}

\item{lty}{Line type for the curve(s). Defaults to 1:(No. of strata).}

\item{printLegend}{Logical, or character ("topleft", "bottomleft",
"topright" or "bottomright"); if \code{TRUE} or character, a legend is added
to the plot if the number of strata is two or more.}

\item{\dots}{Extra parameters passed to 'plot' and 'lines'.}
}
\value{
No return value.
}
\description{
Plot(s) of the hazard, cumulative hazards, and/or the survivor
function(s) for each stratum.
}
\seealso{
\code{\link{tpchreg}}
}
\author{
Göran Broström
}
\keyword{dplot}
\keyword{survival}
