% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranktransform.R
\name{ranktransform}
\alias{ranktransform}
\alias{ranktransform.numeric}
\alias{ranktransform.grouped_df}
\alias{ranktransform.data.frame}
\title{(Signed) rank transformation}
\usage{
ranktransform(x, ...)

\method{ranktransform}{numeric}(x, sign = FALSE, method = "average", verbose = TRUE, ...)

\method{ranktransform}{grouped_df}(
  x,
  select = NULL,
  exclude = NULL,
  sign = FALSE,
  method = "average",
  ...
)

\method{ranktransform}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  sign = FALSE,
  method = "average",
  ...
)
}
\arguments{
\item{x}{Object.}

\item{...}{Arguments passed to or from other methods.}

\item{sign}{Logical, if \code{TRUE}, return signed ranks.}

\item{method}{Treatment of ties. Can be one of \code{"average"} (default), \code{"first"}, \code{"last"}, \code{"random"}, \code{"max"} or \code{"min"}. See \code{\link[=rank]{rank()}} for details.}

\item{verbose}{Toggle warnings on or off.}

\item{select}{Character vector of column names. If \code{NULL} (the default), all variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}
}
\value{
A rank-transformed object.
}
\description{
Transform numeric values with the integers of their rank (i.e., 1st smallest, 2nd smallest, 3rd smallest, etc.). Setting the \code{sign} argument to \code{TRUE} will give you signed ranks, where the ranking is done according to absolute size but where the sign is preserved (i.e., 2, 1, -3, 4).
}
\examples{
ranktransform(c(0, 1, 5, -5, -2))
ranktransform(c(0, 1, 5, -5, -2), sign = TRUE)

head(ranktransform(iris))

}
\seealso{
\code{\link[=normalize]{normalize()}} \code{\link[=standardize]{standardize()}} \code{\link[=change_scale]{change_scale()}}
}
