% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/downlaod_master_index.R
\name{DownloadMasterIndex}
\alias{DownloadMasterIndex}
\title{Retrieves quarterly Master Index.}
\usage{
DownloadMasterIndex(year.array)
}
\arguments{
\item{year.array}{year in integer or integer array containing years for which Master
Index are to be downloaded.}
}
\value{
Function retrieves quarterly Master Index files
from \url{ftp://ftp.sec.gov/edgar} site and returns download status dataframe.
}
\description{
\code{DownloadMasterIndex} retrieves the quarterly Master Index from SEC.org site.
}
\details{
DownloadMasterIndex function takes 'year' as an input parameter from user,
asks the user to locate working directory, download quarterly master index
from ftp://ftp.sec.gov/edgar, strips the headers, converts it into tabular
form, and merges such quarterly tables into yearly tables in RData format.
Function creates new directory 'Master Index' into working directory
to save these Rda Master Index. Please note, for all other functions in this
package needs to locate the same working directory to access these Rda index files.
}
\examples{
\dontrun{

report <- DownloadMasterIndex(1995)
## Download quarterly Master Index files for the year 1990 and stores into yearly
## 1995master.Rda file. It returns download report in dataframe format.

report <- DownloadMasterIndex(c(1994, 1995, 2006))
## Download quarterly Master Index files for the years 1994, 1995, 2006 and stores into
## different {year}master.Rda files. It returns download report in dataframe format.
}
}

