% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_resource.R
\name{filter_resource}
\alias{filter_resource}
\alias{filter_resource.eventlog}
\alias{filter_resource.grouped_eventlog}
\alias{ifilter_resource}
\title{Filter: Resource}
\usage{
filter_resource(eventlog, resources, reverse)

\method{filter_resource}{eventlog}(eventlog, resources, reverse = FALSE)

\method{filter_resource}{grouped_eventlog}(eventlog, resources, reverse = FALSE)

ifilter_resource(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{resources}{A vector of resources identifiers}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based on resource identifiers
}
\details{
#' The method filter_resource can be used to filter on resource identifiers. It has a resources argument,
to which a vector of identifiers can be given. The selection can be negated with the reverse argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
