% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryCyclicalPlots.R
\encoding{UTF-8}
\name{trajectoryCyclicalPlots}
\alias{trajectoryCyclicalPlots}
\alias{cyclePCoA}
\alias{fixedDateTrajectoryPCoA}
\title{Cyclical trajectory plots}
\usage{
cyclePCoA(
  x,
  centered = FALSE,
  sites.colors = NULL,
  cycles.colors = NULL,
  print.names = FALSE,
  print.init.points = FALSE,
  cex.init.points = 1,
  axes = c(1, 2),
  ...
)

fixedDateTrajectoryPCoA(
  x,
  fixedDates.colors = NULL,
  sites.lty = NULL,
  print.names = FALSE,
  add.cyclicalTrajectory = TRUE,
  axes = c(1, 2),
  ...
)
}
\arguments{
\item{x}{The full output of function \code{\link{extractCycles}} or \code{\link{extractFixedDateTrajectories}} as appropriate, an object of class \code{\link{cycles}} or \code{\link{fd.trajectories}}.}

\item{centered}{Boolean. Have the cycles been centered? Default to FALSE.}

\item{sites.colors}{The colors applied to the different sites. The cycles will be distinguished (old to recent) by increasingly lighter tones of the provided colors.}

\item{cycles.colors}{The colors applied to the different cycles. Not compatible with \code{sites.colors}.}

\item{print.names}{A boolean flag to indicate whether the names of cycles or fixed-date trajectories should be printed.}

\item{print.init.points}{A boolean flag to indicate whether an initial point at the start of cycles should be printed (useful to spot the start of cycles in graphs containing many trajectories).}

\item{cex.init.points}{The size of initial points.}

\item{axes}{The pair of principal coordinates to be plotted.}

\item{...}{Additional parameters for function \code{\link{arrows}}.}

\item{fixedDates.colors}{The colors applied to the different fixed dates trajectories. Defaults to a simple RGB circular color palette.}

\item{sites.lty}{The line type for the different sites (see \code{\link{par}}, \code{"lty"}).}

\item{add.cyclicalTrajectory}{A boolean flag to indicate whether the original cyclical trajectory should also be drawn as background.}
}
\value{
Functions \code{cyclePCoA} and \code{fixedDateTrajectoryPCoA} return the results of calling of \code{\link{cmdscale}}.
}
\description{
Plotting functions for Cyclical Ecological Trajectory Analysis:
\itemize{
\item{Function \code{cyclePCoA} removes unwanted points (see details) and performs principal coordinates analysis (\code{\link{cmdscale}}) and draws cycles in the ordination scatterplot.}
\item{Function \code{fixedDateTrajectoryPCoA} performs principal coordinates analysis (\code{\link{cmdscale}}) and draws fixed date trajectories in the ordination scatterplot.}
}
}
\details{
The functions \code{cyclePCoA} and \code{fixedDateTrajectoryPCoA} give adapted graphical representation of cycles and fixed-date trajectories using principal coordinate analysis (PCoA, see \code{\link{cmdscale}}).
Function \code{cyclePCoA} handles external and potential interpolated ecological states so that they are correctly taken in account in PCoA (i.e. avoiding duplication, and reducing the influence of interpolated ecological states as much as possible). In case of centered cycles, the influence of these ecological states will grow as they will not correspond to duplications anymore.
In case of centered cycles, the intended use is to set the parameter \code{centered} to \code{TRUE}.
}
\examples{
#First build a toy dataset with:
#The sampling times of the time series
timesToy <- 0:30 

#The duration of the cycles (i.e. the periodicity of the time series)
cycleDurationToy <- 10 

#The sites sampled (only one named "A")
sitesToy <- rep(c("A"),length(timesToy)) 

#And prepare a trend term
trend <- 0.05

#Build cyclical data (note that we apply the trend only to x):
x <- sin((timesToy*2*pi)/cycleDurationToy)+trend*timesToy
y <- cos((timesToy*2*pi)/cycleDurationToy)
matToy <- cbind(x,y)

#And express it as distances:
dToy <- dist(matToy)

#Make it an object of class trajectory:
cyclicalTrajToy <- defineTrajectories(d = dToy,
                                      sites = sitesToy,
                                      times = timesToy)

#And extract the cycles and fixed date trajectories:
cyclesToy <- extractCycles(x = cyclicalTrajToy,
                           cycleDuration = cycleDurationToy)
fdTrajToy <- extractFixedDateTrajectories(x = cyclicalTrajToy,
                                          cycleDuration = cycleDurationToy)

#CETA plotting functions:
cyclePCoA(cyclesToy)
fixedDateTrajectoryPCoA(fdTrajToy)

#After centering of cycles, set  parameter centered to TRUE in cyclePCoA():
cent_cyclesToy <- centerTrajectories(cyclesToy)
cyclePCoA(cent_cyclesToy, centered = TRUE)


}
\references{
Djeghri et al. (in preparation) Going round in cycles, but going somewhere: Ecological Trajectory Analysis as a tool to decipher seasonality and other cyclical dynamics.
}
\seealso{
\code{\link{trajectoryCyclical}}, \code{\link{cmdscale}}
}
\author{
Nicolas Djeghri, UBO

Miquel De \enc{Cáceres}{Caceres}, CREAF
}
