% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTx.R
\name{LT_logit}
\alias{LT_logit}
\title{Lethal Time Logit}
\usage{
LT_logit(formula, data, p = seq(1, 99, 1), weights,
          subset = NULL, log_x = TRUE, het_sig = NULL,
          conf_level = NULL, long_output = TRUE)
}
\arguments{
\item{formula}{an object of class \code{formula} or one that can be coerced to that class: a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which \code{LT_logit} is called.}

\item{p}{Lethal time (LT) values for given p, example will return a LT50 value if p equals 50. If more than one LT value desired specify by creating a vector.}

\item{weights}{vector of 'prior weights' to be used in the fitting process. Should be a numeric vector and is required for analysis.}

\item{subset}{allows for the data to be subseted if desired. Default set to \code{NULL}.}

\item{log_x}{Default is \code{TRUE} and will calculate results using the antilog10 given that the x variable has been \code{log10} tranformed. If \code{FALSE} results will not be back transformed.}

\item{het_sig}{significance level from person's chi sqaure goodness-of-fit test that is used to decide if a heterogeneity factor is used. \code{NULL} is set to 0.15.}

\item{conf_level}{Adjust confidence level as necessary or \code{NULL} set at 0.95.}

\item{long_output}{default is \code{TRUE} which will return a tibble with all 19 variabless. If \code{FALSE} the tibble returned will consist of the p level, n, the predicted LC for given p level, lower and upper confidence limits and their distances.}
}
\value{
Returns a tibble with predicted LT for given p level, lower CL (LCL), upper CL (UCL), LCL and UCL distance away from LT (LCL_dis & UCL_dis; important for creating a plot), Pearson's chi sqaure goodness-of-fit test (pgof), slope, intercept, slope and intercept p values and standard error, and LT variance.
}
\description{
Calculates lethal time (LT) and
its fiducial confidence limits (CL) using a logit analysis
according to Finney 1971, Wheeler et al. 2006, and Robertson et al. 2007.
}
\examples{
head(lampreytime)

results <- LT_logit((response / total) ~ log10(hour),
p = c(50, 99),
weights = total,
data = lampreytime,
subset = c(month == "May"))

#view calculated LT50 and LT99 for seasonal
#toxicity of a piscicide, 3-trifluoromethyl-4-nitrophenol, to lamprey in 2011

results

#dose-response curve can be plotted using 'ggplot2'

}
\references{
Finney, D.J., 1971. Probit Analysis, Cambridge University Press, Cambridge, England, ISBN: 052108041X

Wheeler, M.W., Park, R.M., and Bailey, A.J., 2006. Comparing median lethal concentration values using confidence interval overlap or ratio tests, Environ. Toxic. Chem. 25(5), 1441-1444.10.1897/05-320R.1

Robertson, J.L., Savin, N.E., Russell, R.M. and Preisler, H.K., 2007. Bioassays with arthropods. CRC press. ISBN: 9780849323317
}
