% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecostatscale.R
\name{var_scale}
\alias{var_scale}
\title{Variance scaling function}
\usage{
var_scale(mvar_b, murho_b, mucov_b = NULL, b = 1, B)
}
\arguments{
\item{mvar_b}{Mean variance of abundance values observed at scale b.}

\item{murho_b}{Mean Pearson correlation coefficient of abundance values observed at scale b, calculated as mucov_b/mvar_b. If NULL, mucov_b is used instead.}

\item{mucov_b}{Mean covariance of abundances observed at scale b. Ignored if mrho_b is not NULL. Defaults to NULL.}

\item{b}{Size of observed scale. Defaults to 1.}

\item{B}{Size of desired scale for extrapolation.}
}
\value{
Extrapolated variance at scale B.
}
\description{
Extrapolate variance observed at spatial or ecological scale b
to a different scale, B. Equivalent to Eq.7a in the main text.
}
\examples{
# extrapolate from scale of 1 to 10 - e.g. from a 1m2 patch to a 10m2 patch
var_scale(mvar_b = 1, murho_b = 0.5, b = 1, B = 10)

# example with 100 simulated species
nsp<-100 # number of species
var_b<-1 # species-level abundance variance
cov_b<-(-0.01) # between-specie abundance covariance
# note - if nsp is large, cov_b must be near zero
# this is because, e.g. many variables cannot all be
# simultaneously negatively correlated

# make a covariance matrix based on var_b and cov_b
sigmamat<-diag(nsp)*var_b+(1-diag(nsp))*cov_b
# simulate 1000 observations of 100 species
sim_x<-mvtnorm::rmvnorm(n=1e3, mean = rep(0,100), sigma = sigmamat)

# calculate mean variance, covariance, and correlation from sim_x
cvmat<-cov(sim_x)
mvar_b<-mean(diag(cvmat))
mucov_b<-mean(cvmat[row(cvmat)!=col(cvmat)])
murho_b<-mucov_b/mvar_b

# test function vs. observation
# note - answers match exactly
var(rowSums(sim_x))
var_scale(mvar_b, murho_b = murho_b, b=1, B=100)
}
