% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productivity_levels.R
\name{productivity_levels}
\alias{productivity_levels}
\title{Productivity Levels}
\usage{
productivity_levels(
  data_exp,
  data_gdp,
  country = "country",
  product = "product",
  value = "value"
)
}
\arguments{
\item{data_exp}{(Type: data.frame, matrix or dgCMatrix) a dataset containing
countries, products and exported values.}

\item{data_gdp}{(Type: data.frame, matrix or dgCMatrix) a dataset
containing countries and per-capita GDP values.}

\item{country}{(Type: character) the column with the countries.
By default this is set to \code{"country"}. Used only if the input is a data.frame.}

\item{product}{(Type: character) the column with the products.
By default this is set to \code{"product"}. Used only if the input is a data.frame.}

\item{value}{(Type: character) the column with the metric for
country-product pairs.
By default this is set to \code{"value"}. Used only if the input is a data.frame.}
}
\value{
A list of two named numeric vectors.
}
\description{
\code{productivity_levels()} computes EXPY and PRODY measures.
}
\details{
The current implementation follows
\insertCite{exportmatters2005}{economiccomplexity} to obtain the
productivity and income levels associated to exports.
}
\examples{
pl <- productivity_levels(
 world_trade_avg_1998_to_2000,
 world_gdp_avg_1998_to_2000
)

# partial view of productivity levels
pl$productivity_level_country[1:5]
pl$productivity_level_product[1:5]

}
\references{
For more information on prody and its applications see:

\insertRef{exportmatters2005}{economiccomplexity}
}
\keyword{functions}
