% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productivity_levels.R
\name{ec_productivity_levels}
\alias{ec_productivity_levels}
\title{Productivity Levels}
\usage{
ec_productivity_levels(data = NULL, c1 = "country", p1 = "product",
  v1 = "value", gdp = NULL, c2 = "country", v2 = "value",
  tbl = FALSE)
}
\arguments{
\item{data}{matrix or tibble/data.frame (e.g. \code{world_trade_2017}).
If the input is a matrix it must be a zero/one matrix with countries in rows
and products in columns.
If the input is a tibble/data.frame it must contain at least three columns
with countries, products and values.}

\item{c1}{string to indicate the column that contains exporting
countries in revealed_comparative_advantage (set to "country" by default)}

\item{p1}{string to indicate the column that contains exported products
in revealed_comparative_advantage (set to "product" by default)}

\item{v1}{string to indicate the column that contains traded values in
revealed_comparative_advantage (set to "value" by default)}

\item{gdp}{vector or tibble/data.frame
(e.g. \code{world_gdp_and_population_2017}).
If the input is a vector it must be a numeric vector with optional names.
If the input is a tibble/data.frame it must contain at least two columns with
countries and values.}

\item{c2}{string to indicate the column that contains exporting
countries in revealed_comparative_advantage (set to "country" by default)}

\item{v2}{string to indicate the column that contains traded values in
revealed_comparative_advantage (set to "value" by default)}

\item{tbl}{when set to TRUE the output will be a tibble instead of a
matrix (default set to FALSE)}
}
\description{
Productivity Levels
}
\examples{
ec_productivity_levels(
  data = ec_trade_1962,
  c1 = "country",
  p1 = "product",
  v1 = "value",
  gdp = ec_gdp_pc_1962,
  c2 = "country",
  v2 = "value",
  tbl = TRUE
)

}
\references{
For more information on prody and its applications see:

\insertRef{atlas2014}{economiccomplexity}

\insertRef{exportmatters2005}{economiccomplexity}
}
\keyword{functions}
