% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_cosponsor.R
\docType{data}
\name{db_cosponsor}
\alias{db_cosponsor}
\title{Dataset from Battaglini, Leone Sciabolazza, Patacchini (2018)}
\format{an object of class \code{data.frame} with 2176 rows and 48 columns
\describe{
\item{id}{unique congressman id.}
\item{time}{categorical variable. It takes 1 if the record refers to the 109th congress, 2 if the record refers to the 110th congress, 3 if the record refers to the 111th congress, 4 if the record refers to the 112th congress, 5 if the record refers to the 113th congress.}
\item{party}{dummy variable taking value 1 if the congressman is a Democrat, and 0 if the congressman is a Republican.}
\item{gender}{dummy variable taking value of 1 if the congressman is female.}
\item{nchair}{dummy variable taking value of 1 if the congressman is a chair of at least one committee.}
\item{margin}{election Margin of Victory of the member of Congress.}
\item{dw}{distance to the center in terms of ideology measured using the absolute value of the first dimension of the dw-nominate score created by McCarty et al. (1997).}
\item{les}{weighted average of the following the number of a congressman’s sponsored bill that were introduced, received any action in committee and beyond committee, passed the House, and became law. It differentially weights commemorative, substantive and significant legislation. Created by Volden C. and Wiseman A. E. (2014).}
\item{majority}{dummy variable taking value of 1 if the member of Congress is a member of the party holding the majority of the seats in the House of Representatives.}
\item{state_leg}{dummy variable taking value of 1 if the member of Congress served in state legislature.}
\item{state_leg_prof}{Squire’s (1992) index of state professionalism relative to Congress.}
\item{speaker}{dummy variable taking value of 1 if the member of Congress is speaker of the House.}
\item{seniority}{number of consecutive years in the House of Representatives.}
\item{maj_leader}{dummy variable taking value of 1 if the member of Congress is member of the majority party leadership, as reported by the Almanac of American Politics.}
\item{min_leader}{dummy variable taking value of 1 if the member of Congress is member of the minority party leadership, as reported by the Almanac of American Politics.}
\item{nowhite}{dummy variable taking value of 1 if the member of Congress is Afro-American or Latino, and 0 otherwise.}
\item{H.102-251}{list of committee dummies. Each one refers to a different committee. The dummy takes value of 1 if the congressman served in the given commitee.}
\item{weights}{for each congressman \emph{i}, the value is equal to the inverse of the variance of LES of all congressmen in \emph{i}'s State of election.}
}}
\usage{
data("db_cosponsor")
}
\description{
Dataset from Battaglini, Leone Sciabolazza, Patacchini (2018)
}
\references{
Battaglini M., V. Leone Sciabolazza, E. Patacchini (2018), "Effectiveness of Connected Legislators", Mimeo.\cr
McCarty, N. M., K. T. Poole, and H. Rosenthal (1997), "Income redistribution and the realignment of American politics", AEIpress. \cr
Squire, P. (1992), "Legislative professionalization and membership diversity in state legislatures", Legislative Studies Quarterly, 17(1) 69-79.\cr
Volden, C., and A. E. Wiseman (2014), "Legislative Effectiveness in the United States Congress The Lawmakers", Cambridge University Press.
}
\keyword{datasets}
