% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_set_key.R
\name{wf_set_key}
\alias{wf_set_key}
\title{Set secret ECMWF token}
\usage{
wf_set_key(key, user = "ecmwfr")
}
\arguments{
\item{key}{token provided by ECMWF}

\item{user}{user (email address) used to sign up for the ECMWF data service,
if only a single user is needed it defaults to ("ecmwfr").}
}
\value{
It invisibly returns the user.
}
\description{
Saves the token to your local keychain under
a service called "ecmwfr".
}
\details{
In systems without keychain management set the option
keyring_backend to `file` (i.e. options(keyring_backend = "file"))
in order to write the keychain entry to an encrypted file.
This mostly pertains to headless Linux systems. The keychain files
can be found in ~/.config/r-keyring.
}
\examples{

\dontrun{
# set key
wf_set_key(key = "123")

# get key
wf_get_key()

# leave user and key empty to open a browser window to the service's website
# and type the key interactively
wf_set_key()

}
}
\seealso{
\code{\link[ecmwfr]{wf_get_key}}
}
\author{
Koen Hufkens
}
