% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_error_bar}
\alias{e_error_bar}
\alias{e_error_bar_}
\title{Error bar}
\usage{
e_error_bar(
  e,
  lower,
  upper,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  ...
)

e_error_bar_(
  e,
  lower,
  upper,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{lower, upper}{Lower and upper error bands.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{y_index}{Indexes of x and y axis.}

\item{x_index}{Indexes of x and y axis.}

\item{coord_system}{Coordinate system to plot against.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add error bars.
}
\examples{
df <- data.frame(
  x = factor(c(1, 2)),
  y = c(1, 5),
  upper = c(1.1, 5.3),
  lower = c(0.8, 4.6)
)

df \%>\% 
  e_charts(x) \%>\% 
  e_bar(y) \%>\% 
  e_error_bar(lower, upper)
  
# timeline
df <- data.frame(
  x = factor(c(1, 1, 2, 2)),
  y = c(1, 5, 3, 4),
  step = factor(c(1, 2, 1, 2)),
  upper = c(1.1, 5.3, 3.3, 4.2),
  lower = c(0.8, 4.6, 2.4, 3.6)
)

df \%>\% 
  group_by(step) \%>\% 
  e_charts(x, timeline = TRUE) \%>\% 
  e_bar(y) \%>\% 
  e_error_bar(lower, upper)

}
