% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{est_prop}
\alias{est_prop}
\alias{est_pct_chg}
\title{Specialized margin-of-error calculations}
\usage{
est_prop(x, y)

est_pct_chg(x, y)
}
\arguments{
\item{x, y}{An \link{estimate} vector. For \code{est_pct_chg()}, calculates the \% change
from \code{x} to \code{y} (i.e., \eqn{(y-x)/x})}
}
\value{
An \link{estimate} vector.
}
\description{
Proportions and percent-change-over-time calculations require different
standard error calculations.
}
\examples{
x = estimate(1, 0.1)
y = estimate(1.5, 0.1)
est_prop(x, y)
est_pct_chg(x, y)

}
