% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrModelInternal.R
\name{internalModelPrep}
\alias{internalModelPrep}
\title{Do internal model preparation for dynr}
\usage{
internalModelPrep(num_regime, dim_latent_var, xstart, ub, lb,
  options = default.model.options, isContinuousTime, infile, outfile,
  compileLib, verbose)
}
\arguments{
\item{num_regime}{An integer number of the regimes.}

\item{dim_latent_var}{An integer number of the latent variables.}

\item{xstart}{The starting values for parameter estimation.}

\item{ub}{The upper bounds of the estimated parameters.}

\item{lb}{The lower bounds of the estimated parameters.}

\item{options}{A list of NLopt estimation options. By default, xtol_rel=1e-7, stopval=-9999, ftol_rel=-1, ftol_abs=-1, maxeval=as.integer(-1), and maxtime=-1.}

\item{isContinuousTime}{A binary flag indicating whether the model is a continuous-time model (FALSE/0 = no; TRUE/1 = yes)}

\item{infile}{Input file name}

\item{outfile}{Output file name}

\item{compileLib}{Whether to compile the libary anew}

\item{verbose}{Logical flag for verbose output}
}
\value{
A list of model statements to be passed to dynr.cook().
}
\description{
Principally, this function takes a host of arguments and gives back
a list that importantly includes the function addresses.
}

