% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xts_util.r
\name{aggregate_xts}
\alias{aggregate_xts}
\title{Resample observation data at a new time interval}
\usage{
aggregate_xts(ser, dt, fun = mean)
}
\arguments{
\item{ser}{xts Times series to aggregate}

\item{dt}{numeric New time interval, hours}

\item{fun}{function  Function applied to aggregate the series to the new interval}
}
\value{
Time series resampled at the new interval
#' @return The list of observations resampled at the new interval.
}
\description{
Takes a list of time series and resample to a new interval.
}
\details{
Time series of observation data are often of different temporal resolutions, however the input to most hydrological models, as is the case with the Dynamic TOPMODEL, requires those data at the same interval. This provides a method to resample a collection of such data to a single interval.
}
\examples{
# Resample Brompton rainfall and PE data to 15 minute intervals
require(dynatopmodel)
data("brompton")

rain <- aggregate_xts(brompton$rain, dt=15/60)
}
