% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Contour-plot_sim.R
\name{plot_cont}
\alias{plot_cont}
\title{Contour plot of simulation results of a bio-geochemical variable.}
\usage{
plot_cont(
  sim,
  sim.start,
  sim.end,
  legend.title,
  min.depth,
  max.depth,
  by.value,
  nlevels
)
}
\arguments{
\item{sim}{a matrix of simulated variables that have been interpolated}

\item{sim.start, sim.end}{the start and end of the simulation period for the DYRESM-CAEDYM model run of interest. The date format must be "\%Y-\%m-\%d".}

\item{legend.title}{the legend title of the contour figure.}

\item{min.depth, max.depth, by.value}{minimum and maximum depth used to be the start of y axis of the contour plot, at the increment of by.value.}

\item{nlevels}{a set of levels which are used to partition the range of simulation variable.}
}
\value{
This function returns a filled.contour object.
}
\description{
Contour plot a matrix of values of a bio-geochemical variable, which can be generated through "interpol" function.
}
\examples{
 # extract simulated temperature values from DYRESM-CAEDYM simulation file
 var.values<-ext_output(dycd.output=system.file("extdata", "dysim.nc", package = "dycdtools"),
                       var.extract=c("TEMP"))

 for(i in 1:length(var.values)){
  expres<-paste0(names(var.values)[i],"<-data.frame(var.values[[",i,"]])")
  eval(parse(text=expres))
 }

# interpolate temperature for depths from 0 to 13 m at increment of 0.5 m
  temp.interpolated<-interpol(layerHeights = dyresmLAYER_HTS_Var,
                             var = dyresmTEMPTURE_Var,
                             min.dept = 0,max.dept = 13,by.value = 0.5)

# contour plot of temperature simulations
  p <- plot_cont(sim=temp.interpolated,
            sim.start="2017-06-06",
            sim.end="2017-06-15",
            legend.title="T \u00B0C",
            min.depth=0,max.depth=13,by.value=0.5,
            nlevels=20)

  p

}
