# Generated by 02-duckplyr_df-methods.R
#' @export
setequal.duckplyr_df <- function(x, y, ...) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    "No relational implementation for {.code setequal()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  setequal <- dplyr$setequal.data.frame
  out <- setequal(x, y, ...)
  return(out)

  # dplyr implementation
  check_dots_empty()
  check_compatible(x, y)

  cast <- vec_cast_common(x = x, y = y)
  all(vec_in(cast$x, cast$y)) && all(vec_in(cast$y, cast$x))
}

duckplyr_setequal <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df_impl(x)
      y <- as_duckplyr_df_impl(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- setequal(x, y, ...)
  out
}
