# Generated by 02-duckplyr_df-methods.R
#' @export
n_groups.duckplyr_df <- function(x) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code n_groups()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  n_groups <- dplyr$n_groups.data.frame
  out <- n_groups(x)
  return(out)

  # dplyr implementation
  nrow(group_data(x))
}

duckplyr_n_groups <- function(x, ...) {
  try_fetch(
    x <- as_duckplyr_df_impl(x),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- n_groups(x, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
