# Generated by 02-duckplyr_df-methods.R
#' @export
rename_with.duckplyr_df <- function(.data, .fn, .cols = everything(), ...) {
  # Our implementation
  rel_try(
    "No relational implementation for rename_with()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  rename_with <- dplyr$rename_with.data.frame
  out <- rename_with(.data, .fn, {{ .cols }}, ...)
  return(out)

  # dplyr implementation
  .fn <- as_function(.fn)
  cols <- tidyselect::eval_select(enquo(.cols), .data, allow_rename = FALSE)

  names <- names(.data)

  sel <- vec_slice(names, cols)
  new <- .fn(sel, ...)

  if (!is_character(new)) {
    cli::cli_abort(
      "{.arg .fn} must return a character vector, not {.obj_type_friendly {new}}."
    )
  }
  if (length(new) != length(sel)) {
    cli::cli_abort(
      "{.arg .fn} must return a vector of length {length(sel)}, not {length(new)}."
    )
  }

  names <- vec_assign(names, cols, new)
  names <- vec_as_names(names, repair = "check_unique")

  set_names(.data, names)
}

duckplyr_rename_with <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- rename_with(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
