# Generated by 02-duckplyr_df-methods.R
#' @export
reframe.duckplyr_df <- function(.data, ..., .by = NULL) {
  # Our implementation
  rel_try(
    "No relational implementation for reframe()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  reframe <- dplyr$reframe.data.frame
  out <- reframe(.data, ..., .by = {{ .by }})
  return(out)

  # dplyr implementation
  by <- compute_by({{ .by }}, .data, by_arg = ".by", data_arg = ".data")

  cols <- summarise_cols(.data, dplyr_quosures(...), by, "reframe")
  out <- summarise_build(by, cols)

  if (!is_tibble(.data)) {
    # The `by` group data we build from is always a tibble,
    # so we have to manually downcast as needed
    out <- as.data.frame(out)
  }

  out
}

duckplyr_reframe <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- reframe(.data, ...)
  out
}
