% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundaries.R
\name{smooth_borders}
\alias{smooth_borders}
\title{smoother borders}
\usage{
smooth_borders(x, r)
}
\arguments{
\item{x}{a real matrix}

\item{r}{a positive integer}
}
\value{
a matrix of the same dimensions as x
}
\description{
let a field decrease linearly towards its edges
}
\details{
Values within the field are linearly reduced from their original value to the field minimum, starting \code{r} pixels away from the edge. This enforces truely periodic boundaries and removes sharp edges.
}
\note{
r must not be larger than \code{min( dim(x) )/2}.
}
\examples{
image( smooth_borders(blossom, r=64), col=gray.colors(128,0,1) )
}
