% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{methods}
\name{getDatesFromDOY}
\alias{getDatesFromDOY}
\title{Get dates from year and day of the year}
\usage{
getDatesFromDOY(year, doy)
}
\arguments{
\item{year}{A vector with the years.}

\item{doy}{A vector with the day of the year. 
It must have the same length as \code{year}.}
}
\value{
A \code{\link[base]{Dates}} object.
}
\description{
This function retrieves the date corresponding to the given 
year and day of the year.
}
\examples{
year = c(2000, 2001)
doy = c(366, 365)
dates = getDatesFromDOY(year, doy)
dates

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\link[dtwSat]{shiftDates}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
