% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twdtwAssess.R
\docType{methods}
\name{twdtwAssess}
\alias{twdtwAssess}
\alias{twdtwAssess,twdtwRaster-method}
\alias{twdtwAssess-twdtwRaster}
\alias{twdtwAssess,data.frame-method}
\alias{twdtwAssess-data.frame}
\alias{twdtwAssess,table-method}
\alias{twdtwAssess-table}
\alias{twdtwAssess,matrix-method}
\alias{twdtwAssess-matrix}
\alias{twdtwAssess,twdtwMatches-method}
\alias{twdtwAssess-twdtwMatches}
\title{Assess TWDTW classification}
\usage{
\S4method{twdtwAssess}{twdtwRaster}(object, y, labels = NULL,
  id.labels = NULL, proj4string = NULL, conf.int = 0.95,
  rm.nosample = TRUE)

\S4method{twdtwAssess}{data.frame}(object, area, conf.int = 0.95,
  rm.nosample = TRUE)

\S4method{twdtwAssess}{table}(object, area, conf.int = 0.95,
  rm.nosample = TRUE)

\S4method{twdtwAssess}{matrix}(object, area, conf.int = 0.95,
  rm.nosample = TRUE)

\S4method{twdtwAssess}{twdtwMatches}(object, area, conf.int, rm.nosample)
}
\arguments{
\item{object}{an object of class \code{\link[dtwSat]{twdtwRaster}} resulting from 
the classification, i.e. \code{\link[dtwSat]{twdtwClassify}}.
The argument can also receive an error matrix (confusion matrix) in using the classes 
\code{\link[base]{data.frame}} or \code{\link[base]{table}}. In this case the user 
must inform the area for each class to the argument \code{area}.}

\item{y}{a \code{\link[base]{data.frame}} whose attributes are: longitude, 
latitude, the start ''from'' and the end ''to'' of the time interval 
for each sample. This can also be a \code{\link[sp]{SpatialPointsDataFrame}} 
whose attributes are the start ''from'' and the end ''to'' of the time interval.
If missing ''from'' and/or ''to'', they are set to the time range of the 
\code{object}.}

\item{labels}{character vector with time series labels. For signature 
\code{\link[dtwSat]{twdtwRaster}} this argument can be used to set the 
labels for each sample in \code{y}, or it can be combined with \code{id.labels} 
to select samples with a specific label.}

\item{id.labels}{a numeric or character with an column name from \code{y} to 
be used as samples labels. Optional.}

\item{proj4string}{projection string, see \code{\link[sp]{CRS-class}}. Used 
if \code{y} is a \code{\link[base]{data.frame}}.}

\item{conf.int}{specifies the confidence level (0-1).}

\item{rm.nosample}{if sum of columns and sum of rows of the error matrix are zero 
then remove class. Default is TRUE.}

\item{area}{a numeric vector with the area for each class if the argument \code{object}
is an error matrix (confusion matrix). If \code{object} is \code{\link[dtwSat]{twdtwMatches}} 
area can be either a vector with the area of each classified object, or a single number 
if the objects are single pixels.}
}
\description{
Performs an accuracy assessment 
of the classified maps. The function returns Overall Accuracy, 
User's Accuracy, Produce's Accuracy, error matrix (confusion matrix),
and estimated area according to [1-2]. The function returns the metrics 
for each time interval and a summary considering all classified intervals.
}
\examples{
\dontrun{

# Create raster time series
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
red = brick(system.file("lucc_MT/data/red.tif", package="dtwSat"))
blue = brick(system.file("lucc_MT/data/blue.tif", package="dtwSat"))
nir = brick(system.file("lucc_MT/data/nir.tif", package="dtwSat"))
mir = brick(system.file("lucc_MT/data/mir.tif", package="dtwSat"))
doy = brick(system.file("lucc_MT/data/doy.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, red, blue, nir, mir, timeline = timeline, doy = doy)

# Read fiels samples 
field_samples = read.csv(system.file("lucc_MT/data/samples.csv", package="dtwSat"))
proj_str = scan(system.file("lucc_MT/data/samples_projection", 
                package="dtwSat"), what = "character")

# Split samples for training (10\%) and validation (90\%) using stratified sampling 
library(caret) 
set.seed(1)
I = unlist(createDataPartition(field_samples$label, p = 0.1))
training_samples = field_samples[I,]
validation_samples = field_samples[-I,]

# Get time series form raster
training_ts = getTimeSeries(rts, y = training_samples, proj4string = proj_str)
validation_ts = getTimeSeries(rts, y = validation_samples, proj4string = proj_str)

# Create temporal patterns 
temporal_patterns = createPatterns(training_ts, freq = 8, formula = y ~ s(x))

# Run TWDTW analysis for raster time series 
log_fun = weight.fun=logisticWeight(-0.1,50)
r_twdtw = twdtwApply(x=rts, y=temporal_patterns, weight.fun=log_fun, format="GTiff", 
                     overwrite=TRUE)
                     
# Classify raster based on the TWDTW analysis 
r_lucc = twdtwClassify(r_twdtw, format="GTiff", overwrite=TRUE)
plot(r_lucc)

# Assess classification 
twdtw_assess = twdtwAssess(object = r_lucc, y = validation_samples, 
                           proj4string = proj_str, conf.int = .95, rm.nosample=TRUE) 
twdtw_assess

# Plot assessment 
plot(twdtw_assess, type="accuracy")
plot(twdtw_assess, type="area")
plot(twdtw_assess, type="map", samples = "all")
plot(twdtw_assess, type="map", samples = "incorrect")
plot(twdtw_assess, type="map", samples = "correct")

# Create latex tables 
twdtwXtable(twdtw_assess, table.type="matrix")
twdtwXtable(twdtw_assess, table.type="accuracy")
twdtwXtable(twdtw_assess, table.type="area")

}

# Total mapped area by class. Data from [1]
area = c(A = 22353, B = 1122543, C = 610228) 

# Error matrix, columns (Reference) rows (Map)
x = 
    rbind(
         c( 97,	 0,   3),
         c(  3, 279,  18),
         c(  2,   1,  97)
   )

table_assess = twdtwAssess(x, area, conf.int = .95)

table_assess

plot(table_assess, type="area", perc=FALSE)

plot(table_assess, type="accuracy")

\dontrun{

# Create raster time series
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
red = brick(system.file("lucc_MT/data/red.tif", package="dtwSat"))
blue = brick(system.file("lucc_MT/data/blue.tif", package="dtwSat"))
nir = brick(system.file("lucc_MT/data/nir.tif", package="dtwSat"))
mir = brick(system.file("lucc_MT/data/mir.tif", package="dtwSat"))
doy = brick(system.file("lucc_MT/data/doy.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, red, blue, nir, mir, timeline = timeline, doy = doy)

# Read fiels samples 
field_samples = read.csv(system.file("lucc_MT/data/samples.csv", package="dtwSat"))
proj_str = scan(system.file("lucc_MT/data/samples_projection", 
                package="dtwSat"), what = "character")

# Split samples for training (10\%) and validation (90\%) using stratified sampling 
library(caret) 
set.seed(1)
I = unlist(createDataPartition(field_samples$label, p = 0.1))
training_samples = field_samples[I,]
validation_samples = field_samples[-I,]

# Get time series form raster
training_ts = getTimeSeries(rts, y = training_samples, proj4string = proj_str)
validation_ts = getTimeSeries(rts, y = validation_samples, proj4string = proj_str)

# Create temporal patterns 
temporal_patterns = createPatterns(training_ts, freq = 8, formula = y ~ s(x))

# Run TWDTW analysis for raster time series 
log_fun = weight.fun=logisticWeight(-0.1,50)
r_twdtw = twdtwApply(x = validation_ts, 
                     y = temporal_patterns, weight.fun = log_fun)

# Accuracy assessment 
twdtw_assess = twdtwAssess(r_twdtw, area = 53664.67, conf.int=.95)
twdtw_assess

plot(twdtw_assess, type="accuracy")
plot(twdtw_assess, type="area")

twdtwXtable(twdtw_assess, table.type="matrix")
twdtwXtable(twdtw_assess, table.type="accuracy")
twdtwXtable(twdtw_assess, table.type="area")

}
}
\references{
[1] Olofsson, P., Foody, G.M., Stehman, S.V., Woodcock, C.E. (2013). 
Making better use of accuracy data in land change studies: Estimating 
accuracy and area and quantifying uncertainty using stratified estimation. 
Remote Sensing of Environment, 129, pp.122-131.

[2] Olofsson, P., Foody G.M., Herold M., Stehman, S.V., Woodcock, C.E., Wulder, M.A. (2014)
Good practices for estimating area and assessing accuracy of land change. Remote Sensing of 
Environment, 148, pp. 42-57.
}
\seealso{
\code{\link[dtwSat]{twdtwClassify}},  
\code{\link[dtwSat]{twdtwAssessment}}, and
\code{\link[dtwSat]{twdtwXtable}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
