% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,twdtwAssessment,ANY-method}
\alias{plot-twdtwAssessment}
\alias{plot,twdtwCrossValidation,ANY-method}
\alias{plot-twdtwTimeSeries}
\alias{plot,twdtwTimeSeries,ANY-method}
\alias{plot-twdtwTimeSeries}
\alias{plot,twdtwMatches,ANY-method}
\alias{plot-twdtwMatches}
\alias{plot,twdtwRaster,ANY-method}
\alias{plot-twdtwRaster}
\title{Plotting twdtw* objects}
\usage{
\S4method{plot}{twdtwAssessment,ANY}(x, type = "area", ...)

\S4method{plot}{twdtwCrossValidation,ANY}(x, type = "crossvalidation", ...)

\S4method{plot}{twdtwTimeSeries,ANY}(x, type = "timeseries", ...)

\S4method{plot}{twdtwMatches,ANY}(x, type = "alignments", ...)

\S4method{plot}{twdtwRaster,ANY}(x, type = "maps", ...)
}
\arguments{
\item{x}{An object of class twdtw*.}

\item{type}{A character for the plot type: ''paths'', ''matches'', 
''alignments'', ''classification'', ''cost'', ''patterns'', ''timeseries'',
''maps'', ''area'', ''changes'', and ''distance''.}

\item{...}{additional arguments to pass to plotting functions.
\code{\link[dtwSat]{plotPaths}}, 
\code{\link[dtwSat]{plotCostMatrix}},
\code{\link[dtwSat]{plotAlignments}}, 
\code{\link[dtwSat]{plotMatches}}, 
\code{\link[dtwSat]{plotClassification}},
\code{\link[dtwSat]{plotPatterns}}, 
\code{\link[dtwSat]{plotTimeSeries}},
\code{\link[dtwSat]{plotMaps}},
\code{\link[dtwSat]{plotArea}}, or
\code{\link[dtwSat]{plotChanges}}.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Methods for plotting objects of class twdtw*.
}
\details{
\describe{
	\item{Plot types}{:
      \cr\code{paths}: Method for plotting the minimum paths in the cost matrix of TWDTW.
      \cr\code{matches}: Method for plotting the matching points from TWDTW analysis.
      \cr\code{alignments}: Method for plotting the alignments and respective TWDTW dissimilarity measures.
      \cr\code{classification}: Method for plotting the classification of each subinterval of the time series based on TWDTW analysis. 
      \cr\code{cost}: Method for plotting the internal matrices used during the TWDTW computation.
      \cr\code{patterns}: Method for plotting the temporal patterns.
      \cr\code{timeseries}: Method for plotting the temporal patterns.
      }
}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
