% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq.R
\name{dtt_seq}
\alias{dtt_seq}
\alias{dtt_seq.Date}
\alias{dtt_seq.POSIXct}
\alias{dtt_seq.hms}
\title{Sequence}
\usage{
dtt_seq(from, to, units, length_out = NULL, ...)

\method{dtt_seq}{Date}(from, to = from, units = "days", length_out = NULL, ...)

\method{dtt_seq}{POSIXct}(from, to = from, units = "seconds", length_out = NULL, ...)

\method{dtt_seq}{hms}(
  from,
  to = from,
  units = "seconds",
  length_out = NULL,
  wrap = TRUE,
  ...
)
}
\arguments{
\item{from}{A date/time scalar of the start.}

\item{to}{A date/time scalar of the end.}

\item{units}{A string of the time units. The possible values are "secs",
"minutes", "hours", "days" or "weeks".}

\item{length_out}{An integer of the number of units from from.}

\item{...}{Unused.}

\item{wrap}{A flag specifying whether to wrap hms vectors from 23:59:59 to 00:00:00}
}
\value{
The date/time vector.
}
\description{
Creates a date/time sequence vector.
from and to are first floored and then a sequence is created by units.
If length_out is defined then that number of units are added to from.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_seq(Date)}: Create a Date sequence vector

\item \code{dtt_seq(POSIXct)}: Create a POSIXct sequence vector

\item \code{dtt_seq(hms)}: Create a hms sequence vector

}}
\examples{
dtt_seq(as.Date("2001-01-01"), as.Date("2001-01-05"))
}
