% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/day-decimal.R
\name{dtt_day_decimal}
\alias{dtt_day_decimal}
\alias{dtt_day_decimal.Date}
\alias{dtt_day_decimal.POSIXct}
\title{Get Decimal Day Values}
\usage{
dtt_day_decimal(x, ...)

\method{dtt_day_decimal}{Date}(x, ...)

\method{dtt_day_decimal}{POSIXct}(x, ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}
}
\value{
A numeric vector.
}
\description{
Gets decimal day values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Get numeric vector of decimal year values for a Date vector

\item \code{POSIXct}: Get numeric vector of decimal year values for a POSIXct vector
}}

\examples{
x <- as.POSIXct("1990-01-03 10:00:01")
dtt_day_decimal(x)
}
\seealso{
\code{\link[=dtt_day]{dtt_day()}}

Other decimal: 
\code{\link{dtt_doy_decimal}()},
\code{\link{dtt_hour_decimal}()},
\code{\link{dtt_minute_decimal}()},
\code{\link{dtt_month_decimal}()},
\code{\link{dtt_year_decimal}()}
}
\concept{decimal}
