% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_count_subgroup}
\alias{p_count_subgroup}
\title{Add a subgroup count to the dtrackr history graph}
\usage{
p_count_subgroup(
  .data,
  .subgroup,
  ...,
  .messages = .defaultCountSubgroup(),
  .headline = .defaultHeadline(),
  .type = "info",
  .asOffshoot = FALSE,
  .tag = NULL,
  .maxsubgroups = .defaultMaxSupportedGroupings()
)
}
\arguments{
\item{.data}{a dataframe which may be grouped}

\item{.subgroup}{a column with a small number of levels (e.g. a factor)}

\item{...}{passed to \verb{base::factor(subgroup values, ...)} to allow reordering of levels etc.}

\item{.messages}{a character vector of glue specifications. A glue
specification can refer to anything from the calling environment and \{.name\}
for the subgroup name, \{.count\} for the subgroup count, \{.subtotal\} for the
current grouping count and \{.total\} for the whole count}

\item{.headline}{a glue specification which can refer to grouping variables
of .data, \{.subtotal\} for the current grouping count, or any variables
defined in the calling environment}

\item{.type}{one of "info","exclusion": used to define formatting}

\item{.asOffshoot}{do you want this comment to be an offshoot of the main
flow (default = FALSE).}

\item{.tag}{if you want to use the summary data from this step in the future then
give it a name with .tag.}

\item{.maxsubgroups}{the maximum number of discrete values allowed in .subgroup is
configurable with \code{options("dtrackr.max_supported_groupings"=XX)}. The
default is 16. Large values produce unwieldy flow charts.}
}
\value{
the same .data dataframe with the history graph updated with a
subgroup count as a new stage
}
\description{
A frequent use case for more detailed description is to have a subgroup count
within a flowchart. This works best for factor subgroup columns but other
data will be converted to a factor automatically. The count of the items in
each subgroup is added as a new stage in the flowchart.
}
\examples{
library(dplyr)
library(dtrackr)
survival::cgd \%>\% track() \%>\% group_by(treat) \%>\%
  count_subgroup(center) \%>\% history()
}
