% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_mutate}
\alias{p_mutate}
\title{Standard dplyr modifying operations}
\usage{
p_mutate(.data, ..., .messages = "", .headline = "", .tag = NULL)
}
\arguments{
\item{.data}{\itemize{
\item a dataframe which may be grouped
}}

\item{...}{a set of dplyr summary expressions.}

\item{.messages}{\itemize{
\item a set of glue specs. The glue code can use any global variable, grouping variable, or \{.strata\}. Defaults to nothing.
}}

\item{.headline}{\itemize{
\item a headline glue spec. The glue code can use any global variable, grouping variable, or \{.strata\}. Defaults to nothing.
}}

\item{.tag}{\itemize{
\item if you want the summary data from this step in the future then give it a name with .tag.
}}
}
\value{
the .data dataframe after being modified by the dplyr equivalent function, but with the history graph updated with a new stage if the \code{.messages} field is not empty
}
\description{
Equivalent Dplyr functions for mutating, selecting and renaming a data set act in the normal way.
mutates / selects / rename generally don't add anything in documentation so the default behaviour is to miss these out of the history.
This can be overridden with the .messages, or .headline values in which case they behave just like a \code{comment()}
See \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:count]{dplyr::add_count()}}, \code{\link[dplyr:count]{dplyr::add_tally()}}, \code{\link[dplyr:mutate]{dplyr::transmute()}}, \code{\link[dplyr:select]{dplyr::select()}}, \code{\link[dplyr:relocate]{dplyr::relocate()}}, \code{\link[dplyr:rename]{dplyr::rename()}}
\code{\link[dplyr:rename]{dplyr::rename_with()}}, \code{\link[dplyr:arrange]{dplyr::arrange()}} for more details.
}
\seealso{
dplyr::mutate()
}
