% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linComb.R
\name{helper_PT}
\alias{helper_PT}
\title{Helper function for PT method.}
\usage{
helper_PT(lambda, neg.set, pos.set)
}
\arguments{
\item{lambda}{a \code{numeric} parameter that will be estimated in minmax
method for the combination score}

\item{neg.set}{a \code{numeric} data frame that contains the observation with
negative status}

\item{pos.set}{a \code{numeric} data frame that contains the observation with
positive status}
}
\value{
A \code{numeric} value for the estimated optimized value
}
\description{
The \code{helper_PT} function estimates the optimized value of
given biomarkers for the PT method.
}
\examples{
# call data
data(exampleData1)

# define the function parameters
markers <- cbind(exampleData1$ddimer, exampleData1$log_leukocyte)
status <- factor(exampleData1$group, levels = c("not_needed", "needed"))

neg.set <- markers[status == levels(status)[1], ]
pos.set <- markers[status == levels(status)[2], ]

lambda <- 0.5

stat <- helper_PT(lambda, neg.set = neg.set, pos.set = pos.set)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
