% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transect.R
\docType{class}
\name{Transect-class}
\alias{Transect-class}
\title{S4 Class "Transect"}
\description{
Virtual Class "Transect"
}
\details{
Virtual Class \code{"Transect"} is an S4 class detailing a single survey, a
single set of transects.
}
\section{Slots}{

\describe{
\item{\code{strata.names}}{a character vector of the strata names}

\item{\code{design}}{Describes the design algorithm used to create the survey.}

\item{\code{samplers}}{Contains the survey transects}

\item{\code{strata.area}}{The areas of the strata in the design}

\item{\code{cov.area}}{The total areas sampled within each strata. Areas sampled
twice are counted twice.}

\item{\code{cov.area.polys}}{The polygons representing the covered area of the
survey.}

\item{\code{samp.count}}{Numeric value(s) giving the number of realised transects.}

\item{\code{effort.allocation}}{a vector of probabilities determining how effort is
allocated between strata. Effort allocated based on area if left empty.}

\item{\code{spacing}}{determines the spacing of systematic samplers}

\item{\code{design.angle}}{numeric value detailing the angle of the design. Can provide
multiple values relating to strata. The use of the angle varies with design, it
can be either the angle of the grid of points, the angle of lines or the design
axis for the zigzag design.}

\item{\code{edge.protocol}}{character value indicating whether a "plus" sampling or
"minus" sampling protocol is used.}
}}

\seealso{
\code{\link{make.design}}
}
\keyword{classes}
