% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeta.R
\name{zeta}
\alias{zeta}
\title{Zeta}
\usage{
zeta(x, deriv = 0)
}
\arguments{
\item{x}{numeric vector of quantiles. Missing values (NAs) and Inf are allowed.}

\item{deriv}{derivative of order \code{deriv} of the zeta function. Available are \code{0}, \code{2} and \code{4}.}
}
\value{
Evaluates the zeta function.  If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian}, \code{l3} and \code{l4}.
}
\description{
Evaluates the zeta function, i.e. \code{log(2*pnorm(x))}.
}
\details{
The zeta function is defined as \eqn{log\{ 2 \Phi(x)\}}. The function is a clone of \code{\link[sn:zeta]{zeta()}}.
}
\examples{
zeta(1,1)

}
\references{
\itemize{
\item \insertRef{abramowitz1964handbook}{dsfa}
\item \insertRef{azzalini2014collaboration}{dsfa}
}
}
