% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop.R
\name{dcop}
\alias{dcop}
\alias{pcop}
\alias{rcop}
\title{Copula distribution}
\usage{
dcop(
  U,
  Tau = 0,
  family = 1,
  deriv = 0,
  disjoint = TRUE,
  num = FALSE,
  log.p = FALSE
)

pcop(U, Tau = 0, family = 1, log.p = FALSE)

rcop(n, Tau = 0, family = 1)
}
\arguments{
\item{U}{matrix of pseudo observations. Must have two columns.}

\item{Tau}{matrix of Kendall's tau.}

\item{family}{integer, defines the copula family:\cr
\code{1} = Gaussian copula \cr}

\item{deriv}{derivative of order \code{deriv} of the log density. Available are 1,2,3,4.}

\item{disjoint}{logical; if TRUE, only derivatives with respect to Tau are provided.}

\item{num}{logical; if TRUE, numerical derivatives are provided.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations.}
}
\value{
\code{dcopula} gives the density, \code{pcop} gives the distribution function for a specified copula and \code{rcop} generates random numbers, with given Tau.
If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian}, \code{l3} and \code{l4} of the output of the density.
}
\description{
Probablity density function and random number generation for the normal, frank and gumbel bivariate copula.
}
\details{
For more than 2 dimensions only the gaussian copula is implemented. The functions \code{pcop} and \code{rcop} are wrapper functions for the \code{VineCopula} package.
}
\section{Functions}{
\itemize{
\item \code{pcop()}: distribution function for the joint distribution.

\item \code{rcop()}: random number generation for the joint distribution.

}}
\examples{
pdf <- dcop(U=matrix(c(0.3,0.7), ncol=2), Tau=matrix(0.5,ncol=1), family=1)
cdf <- pcop(U=matrix(c(0.3,0.7), ncol=2), Tau=matrix(0.5,ncol=1), family=1)
r <- rcop(n=100, Tau=matrix(0.5,nrow=100), family=1)

}
\references{
\itemize{
\item \insertRef{schepsmeier2014derivatives}{dsfa}
\item \insertRef{hofert2018elements}{dsfa}
}
}
