% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsem.R
\name{dsem_control}
\alias{dsem_control}
\title{Detailed control for dsem structure}
\usage{
dsem_control(
  quiet = FALSE,
  run_model = TRUE,
  use_REML = TRUE,
  parameters = NULL,
  map = NULL
)
}
\arguments{
\item{quiet}{Boolean indicating whether to run model printing messages to terminal or not;}

\item{run_model}{Boolean indicating whether to estimate parameters (the default), or
instead to return the model inputs and compiled TMB object without running;}

\item{use_REML}{Boolean indicating whether to treat non-variance fixed effects as random,
either to motigate bias in estimated variance parameters or improve efficiency for
parameter estimation given correlated fixed and random effects}

\item{parameters}{list of fixed and random effects, e.g., as constructed by \code{dsem} and then modified
by hand (only helpful for advanced users to change starting values or restart at intended values)}

\item{map}{list of fixed and mirrored parameters, constructed by \code{dsem} by default but available
to override this default and then pass to \code{\link[TMB]{MakeADFun}}}
}
\value{
An S3 object of class "dsem_control" that specifies detailed model settings,
allowing user specification while also specifying default values
}
\description{
Define a list of control parameters.  Note that
the format of this input is likely to change more rapidly than that of
\code{\link{dsem}}
}
