% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSDI.R
\name{MSDI}
\alias{MSDI}
\title{Compute the Multivariate Standardized Drought Index (MSDI)}
\usage{
MSDI(X, Y, ts = 6)
}
\arguments{
\item{X}{is the vector of a monthly hydro-climatic variable of n years.}

\item{Y}{is the vector of a monthly hydro-climatic variable of n years.}

\item{ts}{is the accumulated time scale.}
}
\value{
The monthly MSDI series of different time scales (based on Gringorten plotting position)
}
\description{
Based on a pair of monthly hydro-climatic variable (or corresponding marginals), 
the MSDI is computed using the joint distribution (parametric or nonparametric forms). 
The current version is based on the Gringorten plotting position.
It can be extended to higher dimensions, such as trivariate case including meteorological, 
agricultural, and hydrological droughts. For the high dimension case, the copula
 or vine copula method can be employed
}
\examples{

X=runif(120, min = 0, max = 100) # 10-year monthly data
Y=runif(120, min = 0, max = 100) # 10-year monthly data
fit<-MSDI(X,Y,ts=6) # Compute the 6 month drought index
fit$ProbEmp2 #Get the empirical drought index (e.g.,Gringorten plotting position )

}
\references{
Hao and AghaKouchak (2013) Multivariate Standardized Drought Index: A parametric multi-index model, Advances in Water Resources 57, 12-18.
}
