% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic2.R
\name{logistic2_fn}
\alias{logistic2_fn}
\title{2-parameter logistic function}
\usage{
logistic2_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the logistic function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}. \code{alpha} can only be equal to 0 or 1 while
\code{delta} can only be equal to 1 or -1.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
logistic function.
}
\description{
Evaluate at a particular set of parameters the 2-parameter logistic function.
}
\details{
The 2-parameter logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = 1 / (1 + exp(-eta * (x - phi)))}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{theta = c(alpha, delta, eta, phi)} and \code{eta > 0}. Only \code{eta} and \code{phi}
are free to vary (therefore the name) while vector \code{c(alpha, delta)} is
constrained to be either \code{c(0, 1)} (monotonically increasing curve) or
\code{c(1, -1)} (monotonically decreasing curve).

This function allows values other than \verb{\{0, 1, -1\}} for \code{alpha} and \code{delta}
but will coerce them to their proper constraints.
}
