% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRepo.R
\name{addRepo}
\alias{addRepo}
\alias{drat:::add}
\alias{add}
\title{Add a (drat) repository to the current session}
\usage{
addRepo(account, alturl)

add(...)
}
\arguments{
\item{account}{Character vector with one or more GitHub account for
which a \sQuote{drat} archive is to be added.}

\item{alturl}{Alternative repo specification with a complete url
string. If \sQuote{alturl} is provided, a single \sQuote{account}
must be provided as well.  For file-based access, the URL format
has to follow the \code{file:/some/path/} format starting with
\sQuote{file} followed by a single colon.}

\item{...}{For the aliases variant, a catch-all collection of
parameters.}
}
\value{
The altered set of repositories
}
\description{
R can use multiple archives: CRAN, BioConductor and Omegahat have
been supported for years.  It is equally easy to add local
archives from the same machine, or local network, or university /
company network as well as other publically available
repositories.  This function aids in the process, and defaults to
adding a \sQuote{drat} archive at GitHub under the given account.
}
\details{
This function retrieves the current set of repositories (see
\code{getOption("repos")} for the current values) and adds
(or overwrites) the entry for the given \sQuote{account}. For
non-GitHub repositories an alternative URL can be specified as
\sQuote{alturl} (and assigned to \sQuote{account} as well).


An aliased function \code{add} is also available, but not exported
via \code{NAMESPACE} to not clobber a possibly unrelated function;
use it via \code{drat:::add()}.
}
\examples{
\dontrun{
  addRepo("drat")                            # adds GitHub repo via default URL
  addRepo(c("eddelbuettel", "ghrr"))         # ditto but adds two repos at once

  addRepo("LocalRepo", "file:/nas/R/repo")   # adds local file-based repo,
                                             # assumes you can read /nas/R/repo
}
}
\author{
Dirk Eddelbuettel
}
