% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cached_planned}
\alias{cached_planned}
\title{List targets in both the plan and the cache.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
cached_planned(
  plan,
  path = NULL,
  cache = drake::drake_cache(path = path),
  namespace = NULL,
  jobs = 1
)
}
\arguments{
\item{plan}{A drake plan.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{namespace}{Character scalar, name of the storr namespace
to use for listing objects.}

\item{jobs}{Number of jobs/workers for parallel processing.}
}
\value{
A character vector of target and sub-target names.
}
\description{
Includes dynamic sub-targets as well.
See examples for details.
}
\examples{
\dontrun{
isolate_example("cache_planned() example", {
plan <- drake_plan(w = 1)
make(plan)
cached_planned(plan)
plan <- drake_plan(
  x = seq_len(2),
  y = target(x, dynamic = map(x))
)
cached_planned(plan)
make(plan)
cached_planned(plan)
cached()
})
}
}
\seealso{
\code{\link[=cached]{cached()}}, \link{cached_unplanned}
}
