% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_drake_triggers.R
\name{drake_triggers}
\alias{drake_triggers}
\title{\code{drake_triggers} helper}
\usage{
drake_triggers(
  command = TRUE,
  depend = TRUE,
  file = TRUE,
  seed = TRUE,
  format = TRUE,
  condition = FALSE,
  change = NULL,
  mode = c("whitelist", "blacklist", "condition")
)
}
\arguments{
\item{command}{Logical, whether to rebuild the target if the
\code{\link[=drake_plan]{drake_plan()}} command changes.}

\item{depend}{Logical, whether to rebuild if a
non-file dependency changes.}

\item{file}{Logical, whether to rebuild the target
if a \code{\link[=file_in]{file_in()}}/\code{\link[=file_out]{file_out()}}/\code{\link[=knitr_in]{knitr_in()}} file changes.
Also applies to external data tracked with
\code{target(format = "file")}.}

\item{seed}{Logical, whether to rebuild the target
if the seed changes. Only makes a difference if you set
a custom \code{seed} column in your \code{\link[=drake_plan]{drake_plan()}} at some point
in your workflow.}

\item{format}{Logical, whether to rebuild the target if the
choice of specialized data format changes: for example,
if you use \code{target(format = "qs")} one instance and
\code{target(format = "fst")} the next. See
\url{https://books.ropensci.org/drake/plans.html#special-data-formats-for-targets} # nolint
for details on formats.}

\item{condition}{R code (expression or language object)
that returns a logical. The target will rebuild
if the code evaluates to \code{TRUE}.}

\item{change}{R code (expression or language object)
that returns any value. The target will rebuild
if that value is different from last time
or not already cached.}

\item{mode}{A character scalar equal to \code{"whitelist"} (default) or
\code{"blacklist"} or \code{"condition"}. With the \code{mode} argument, you can choose
how the \code{condition} trigger factors into the decision to build
or skip the target. Here are the options.
\itemize{
\item \code{"whitelist"} (default): we \emph{rebuild} the target whenever \code{condition}
evaluates to \code{TRUE}. Otherwise, we defer to the other triggers.
This behavior is the same as the decision rule described in the
"Details" section of this help file.
\item \code{"blacklist"}: we \emph{skip} the target whenever \code{condition} evaluates
to \code{FALSE}. Otherwise, we defer to the other triggers.
\item \code{"condition"}: here, the \code{condition} trigger is the only decider,
and we ignore all the other triggers. We \emph{rebuild} target whenever
\code{condition} evaluates to \code{TRUE} and \emph{skip} it whenever \code{condition}
evaluates to \code{FALSE}.
}}
}
\description{
Triggers of a target.
}
\keyword{internal}
