% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envir.R
\name{drake_envir}
\alias{drake_envir}
\title{Get the environment where drake builds targets}
\usage{
drake_envir()
}
\value{
The environment where \code{drake} builds targets.
}
\description{
Call this function inside the commands in your plan
to get the environment where \code{drake} builds targets.
That way, you can strategically remove targets from memory
while \code{\link[=make]{make()}} is running. That way, you can limit the
amount of computer memory you use.
}
\examples{
plan <- drake_plan(
  large_data_1 = sample.int(1e4),
  large_data_2 = sample.int(1e4),
  subset = c(large_data_1[seq_len(10)], large_data_2[seq_len(10)]),
  summary = {
    print(ls(envir = drake_envir()))
    # We don't need the large_data_* targets in memory anymore.
    rm(large_data_1, large_data_2, envir = drake_envir())
    print(ls(envir = drake_envir()))
    mean(subset)
  },
  strings_in_dots = "literals"
)
make(plan, cache = storr::storr_environment(), session_info = FALSE)
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=target]{target()}}
}
