% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outdated.R
\name{outdated}
\alias{outdated}
\title{List the targets that are out of date.}
\usage{
outdated(config = drake::read_drake_config(), make_imports = TRUE,
  do_prework = TRUE)
}
\arguments{
\item{config}{option internal runtime parameter list
produced with \code{\link[=drake_config]{drake_config()}}.
You must use a fresh \code{config} argument with an up-to-date
\code{config$targets} element that was never modified by hand.
If needed, rerun \code{\link[=drake_config]{drake_config()}} early and often.
See the details in the help file for \code{\link[=drake_config]{drake_config()}}.}

\item{make_imports}{logical, whether to make the imports first.
Set to \code{FALSE} to save some time and risk obsolete output.}

\item{do_prework, }{whether to do the \code{prework}
normally supplied to \code{\link[=make]{make()}}.}
}
\value{
Character vector of the names of outdated targets.
}
\description{
Outdated targets will be rebuilt in the next
\code{\link[=make]{make()}}.
}
\details{
\code{outdated()} is sensitive to the alternative triggers
described at
\url{https://ropenscilabs.github.io/drake-manual/debug.html}. # nolint
For example, even if \code{outdated(...)} shows everything up to date,
\code{outdated(..., trigger = "always")} will show
all targets out of date.
You must use a fresh \code{config} argument with an up-to-date
\code{config$targets} element that was never modified by hand.
If needed, rerun \code{\link[=drake_config]{drake_config()}} early and often.
See the details in the help file for \code{\link[=drake_config]{drake_config()}}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Recopute the config list early and often to have the
# most current information. Do not modify the config list by hand.
config <- drake_config(my_plan)
outdated(config = config) # Which targets are out of date?
config <- make(my_plan) # Run the projects, build the targets.
# Now, everything should be up to date (no targets listed).
outdated(config = config)
# outdated() is sensitive to triggers.
# See the debugging guide: https://ropenscilabs.github.io/drake-manual/debug.html # nolint
config$trigger <- "always"
outdated(config = config)
})
}
}
\seealso{
\code{\link[=drake_config]{drake_config()}}, \code{\link[=missed]{missed()}}, \code{\link[=drake_plan]{drake_plan()}},
\code{\link[=make]{make()}}
}
