% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make}
\alias{make}
\title{Function \code{make}}
\usage{
make(plan, targets = drake::possible_targets(plan), envir = parent.frame(),
  verbose = TRUE, cache = NULL,
  parallelism = drake::default_parallelism(), jobs = 1,
  packages = (.packages()), prework = character(0),
  prepend = character(0), command = "make",
  args = drake::default_system2_args(jobs = jobs, verbose = verbose),
  return_config = FALSE, clear_progress = TRUE, imports_only = FALSE)
}
\arguments{
\item{plan}{workflow plan data frame.
A workflow plan data frame is a data frame
with a \code{target} column and a \code{command} column.
Targets are the objects and files that drake generates,
and commands are the pieces of R code that produce them.
Use the function \code{\link{plan}()} to generate workflow plan
data frames easily, and see functions \code{\link{analyses}()},
\code{\link{summaries}()}, \code{\link{evaluate}()},
\code{\link{expand}()}, and \code{\link{gather}()} for
easy ways to generate large workflow plan data frames.}

\item{targets}{character string, names of targets to build.
Dependencies are built too.}

\item{envir}{environment to use. Defaults to the current
workspace, so you should not need to worry about this
most of the time. A deep copy of \code{envir} is made,
so you don't need to worry about your workspace being modified
by \code{make}. The deep copy inherits from the global environment.
Wherever necessary, objects and functions are imported
from \code{envir} and the global environment and
then reproducibly tracked as dependencies.}

\item{verbose}{logical, whether to print progress to the console.
Skipped objects are not printed.}

\item{cache}{drake cache as created by \code{\link{new_cache}()}.
See also \code{\link{get_cache}()}, \code{\link{this_cache}()},
and \code{\link{recover_cache}()}}

\item{parallelism}{character, type of parallelism to use.
To list the options, call \code{\link{parallelism_choices}()}.
For detailed explanations, see \code{?\link{parallelism_choices}},
the tutorial vignettes, or the tutorial files generated by
\code{\link{example_drake}("basic")}}

\item{jobs}{number of parallel processes or jobs to run.
See \code{\link{max_useful_jobs}()} or \code{\link{plot_graph}()}
to help figure out what the number of jobs should be.
Windows users should not set \code{jobs > 1} if
\code{parallelism} is \code{"mclapply"} because
\code{\link{mclapply}()} is based on forking. Windows users
who use \code{parallelism == "Makefile"} will need to
download and install Rtools.

If \code{parallelism} is \code{"Makefile"},  Makefile-level parallelism is
only used for targets in your workflow plan data frame, not imports.  To
process imported objects and files, drake selects the best parallel backend
for your system and uses the number of jobs you give to the \code{jobs}
argument to \code{\link{make}()}. To use at most 2 jobs for imports and at
most 4 jobs for targets, run
\code{make(..., parallelism = "Makefile", jobs = 2, args = "--jobs=4")}}

\item{packages}{character vector packages to load, in the order
they should be loaded. Defaults to \code{(.packages())}, so you
shouldn't usually need to set this manually. Just call
\code{\link{library}()} to load your packages before \code{make()}.
However, sometimes packages need to be strictly forced to load
in a certian order, especially if \code{parallelism} is
\code{"Makefile"}. To do this, do not use \code{\link{library}()}
or \code{\link{require}()} or \code{\link{loadNamespace}()} or
\code{\link{attachNamespace}()} to load any libraries beforehand.
Just list your packages in the \code{packages} argument in the order
you want them to be loaded.
If \code{parallelism} is \code{"mclapply"},
the necessary packages
are loaded once before any targets are built. If \code{parallelism} is
\code{"Makefile"}, the necessary packages are loaded once on
initialization and then once again for each target right
before that target is built.}

\item{prework}{character vector of lines of code to run
before build time. This code can be used to
load packages, set options, etc., although the packages in the
\code{packages} argument are loaded before any prework is done.
If \code{parallelism} is \code{"mclapply"}, the \code{prework}
is run once before any targets are built. If \code{parallelism} is
\code{"Makefile"}, the prework is run once on initialization
and then once again for each target right before that target is built.}

\item{prepend}{lines to prepend to the Makefile if \code{parallelism}
is \code{"Makefile"}. See the vignettes
(\code{vignette(package = "drake")})
to learn how to use \code{prepend}
to take advantage of multiple nodes of a supercomputer.}

\item{command}{character scalar, command to call the Makefile
generated for distributed computing.
Only applies when \code{parallelism} is \code{"Makefile"}.
Defaults to the usual \code{"make"}, but it could also be
\code{"lsmake"} on supporting systems, for example.
\code{command} and \code{args} are executed via
\code{\link{system2}(command, args)} to run the Makefile.
If \code{args} has something like \code{"--jobs=2"}, or if
\code{jobs >= 2} and \code{args} is left alone, targets
will be distributed over independent parallel R sessions
wherever possible.}

\item{args}{command line arguments to call the Makefile for
distributed computing. For advanced users only. If set,
\code{jobs} and \code{verbose} are overwritten as they apply to the
Makefile.
\code{command} and \code{args} are executed via
\code{\link{system2}(command, args)} to run the Makefile.
If \code{args} has something like \code{"--jobs=2"}, or if
\code{jobs >= 2} and \code{args} is left alone, targets
will be distributed over independent parallel R sessions
wherever possible.}

\item{return_config}{logical, whether to return the internal list
of runtime configuration parameters used by \code{make()}}

\item{clear_progress}{logical, whether to clear the saved record of
progress seen by \code{\link{progress}()} and \code{\link{in_progress}()}
before anything is imported or built.}

\item{imports_only}{logical, whether to skip building the targets
in \code{plan} and just import objects and files.}
}
\description{
Run your project (build the targets).
}
\examples{
\dontrun{
load_basic_example()
outdated(my_plan) # Which targets need to be (re)built?
my_jobs = max_useful_jobs(my_plan) # Depends on what is up to date.
make(my_plan, jobs = my_jobs) # Build what needs to be built.
outdated(my_plan) # Everything is up to date.
reg2 = function(d){ # Change one of your functions.
 d$x3 = d$x^3
  lm(y ~ x3, data = d)
}
outdated(my_plan) # Some targets depend on reg2().
plot_graph(my_plan) # See how they fit in an interactive graph.
make(my_plan) # Rebuild just the outdated targets.
outdated(my_plan) # Everything is up to date again.
plot_graph(my_plan) # The colors changed in the graph.
}
}
\seealso{
\code{\link{plan}}, \code{\link{plot_graph}},
\code{\link{max_useful_jobs}}, \code{\link{shell_file}}
}
