% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data_selection.R
\name{data_selection}
\alias{data_selection}
\title{Extracts samples information from a lum_export object or data.frame}
\usage{
data_selection(x, ecfile = NULL, flagsfile = NULL, backname = "Back",
    stanname = "Stan", posname = "Con", unkname = NULL,
    byvar.ecfile = c("analyte", "sample"), byvar.flagsfile = c("well",
    "analyte"), fsample = "sample", fanalyte = "analyte", fbatch = "plate",
    ...)
}
\arguments{
\item{x}{a \code{lum_export} object or \code{data.frame} with
samples information.}

\item{ecfile}{a \code{data.frame} or CSV path file with the
expected concentration in order to merge to \code{x}.}

\item{flagsfile}{a \code{data.frame} or CSV path with the flags
information in order to merge to \code{x}.}

\item{backname}{character vector or list of the background samples
identification of \code{x}.}

\item{stanname}{character vector or list of the standard points
identification of \code{x}.}

\item{posname}{character vector or list  of the positive controls
identification of \code{x}.}

\item{unkname}{character vector or list of the samples identification
of \code{x}. Default \code{NULL}.}

\item{byvar.ecfile}{character vector of the merging variable(s)
of \code{x} and \code{ecfile}.}

\item{byvar.flagsfile}{character vector of the merging variable(s)
of \code{x} and \code{flagsfile}.}

\item{fsample}{character vector of the name of the sample variable.}

\item{fanalyte}{character vector of the name of the analyte variable.}

\item{fbatch}{character vector of the name of the Batch variable.}

\item{...}{other options. Ignored.}
}
\value{
The name of the batch in a list format with the following
components: background, standard, positive and unknowns datasets.
}
\description{
Extracts from a \code{lum_export} or \code{data.frame} object controls,
dilutions points, background and samples to be calibrated.
These files can be merged to an expected concentration and flag dataset.
}
\details{
Default method for identifying background, standard and
positives samples is to define a character vector of length one and
apply \code{\link{agrep}} functions in order to extract databases.
Samples to be calibrated (unknowns) are identified as the
remaining ones (default \code{NULL}).

If the arguments are defined as a list the function will
subset exactly that information from \code{x} object.

The expected concentration file is merged based on \code{byvar.ecfile}.
Only applies when \code{ecfile} is not \code{NULL}. Same applies for flags file.
A variable named 'flag' must be in flags data in order to perform the merge.
}
\examples{
# Load data
data(ecdata)
data(mfidata)

dat <- subset(mfidata,plate=="plate_1" & analyte=="FGF")

# Example 1
sdf <- data_selection(dat)

lapply(sdf$plate_1, function(x) head(x))

# Example 2 (merge ecdata)
sdf <- data_selection(dat, ecfile = ecdata,
             byvar.ecfile=c("analyte","sample"))

lapply(sdf$plate_1, function(x) head(x))

# Example 3 (extract specific samples names with list)
sdf <- data_selection(dat,
             stanname=list("Standard10"),
             backname = list("Background0"),
             posname = list("Control1","Control2"),
             unkname = list("B_sid_13_CSP"))

lapply(sdf$plate_1, function(x) head(x))

# Example 4 (extract aproximate names samples)
sdf <- data_selection(dat,
             stanname="Standard1",
             backname = "Background0",
             posname = "Control1",
             unkname = "B_sid_13_CSP")

lapply(sdf$plate_1, function(x) (x))
}

