% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SSFunctions.R
\docType{data}
\name{SSexp}
\alias{SSexp}
\title{Self-Starting Nls exponential regression model}
\format{A selfStart model}
\usage{
SSexp(x, b, y0)
}
\arguments{
\item{x}{a numeric vector of values at which to evaluate the model}

\item{b}{a numeric parameter representing the growth rate}

\item{y0}{a numeric parameter representing the value of the response when
x is 0}
}
\value{
The value returned is a list containing the nonlinear function,
the self starter function and the parameter names.
}
\description{
This selfStart model evaluates the exponential growth
regression model and its gradient. It has an \code{initial}
attribute that will evaluate initial estimates of the parameters
\code{y0}, and \code{b} for a given set of data. Instead of the standard
\code{exp} function this implementation use the \code{10^} function.
\deqn{f(x)=y_0 \times 10^b}
}
\examples{
# Load data
data(ecdata)
data(mfidata)

# Select analyte FGF for plate 1
dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)$plate_1

ig <- scluminex("plate_1",sdf$standard, sdf$background,
            lfct="SSexp",
            bkg="ignore",
            fmfi="mfi",
            verbose=FALSE)

summary(ig)
}
\author{
John Aponte <john.aponte@cresib.cat>
}
\keyword{datasets}

