% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_helptag.R
\name{dq_helptag}
\alias{dq_helptag}
\title{Creates a help symbol with the given title as popover}
\usage{
dq_helptag(title, trigger = "hover", width = 200, style = NULL)
}
\arguments{
\item{title}{Title to show in the popover.}

\item{trigger}{Optional, can either be 'hover' to show the popover while the
mouse is over the icon or 'focus' to show it while the tag is in focus.}

\item{width}{Optional, width of the popover, can be numeric or character
including any valid CSS unit.}

\item{style}{Optional character, additional style attributes for the tag.}
}
\value{
shiny tag holding the help icon
}
\description{
Creates a help symbol with the given title as a popover.
Trigger to show the popover can either be a mouse hover or a mouse click
to show it until the user clicks again. Info tags can be added to shiny
input labels via tagLists.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    init(),
    fluidRow(
      column(3,
        dq_helptag(
        "This info is visible after an click!<br>
        Line breaks are also possible btw...",
                  trigger = "focus"
                  ),
        textInput("importantValue",
          tagList("Important Value",
            dq_helptag(
            "This is an important value, you have to put something in!"
            ))
      ))
    )),
  server = function(input, output) {
  }
)

}
}
\author{
richard.kunze
}
