% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src-sqlite.r
\name{src_memdb}
\alias{memdb_frame}
\alias{src_memdb}
\title{Per-session in-memory SQLite databases.}
\usage{
src_memdb()

memdb_frame(..., .name = random_table_name())
}
\arguments{
\item{...}{A set of name-value pairs. Arguments are evaluated sequentially,
so you can refer to previously created variables.}

\item{.name}{Name of table in database: defaults to a random name that's
unlikely to conflict with exist}
}
\description{
\code{src_memdb} lets you easily access a sessio-temporary in-memory
SQLite database. \code{memdb_frame()} works like \code{\link{data_frame}},
but instead of creating a new data frame in R, it creates a table in
\code{src_memdb}
}
\examples{
if (require("RSQLite")) {
src_memdb()

df <- memdb_frame(x = runif(100), y = runif(100))
df \%>\% arrange(x)
df \%>\% arrange(x) \%>\% show_query()
}
}

